/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3003;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5216;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5452;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6646;
import net.minecraft.class_6658;
import net.minecraft.class_6731;
import net.minecraft.class_6732;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.blockpredicates.BlockPredicates;
import org.betterx.bclib.api.v3.levelgen.features.config.PlaceFacingBlockConfig;
import org.betterx.bclib.api.v3.levelgen.features.placement.All;
import org.betterx.bclib.api.v3.levelgen.features.placement.Extend;
import org.betterx.bclib.api.v3.levelgen.features.placement.FindSolidInDirection;
import org.betterx.bclib.api.v3.levelgen.features.placement.ForAll;
import org.betterx.bclib.api.v3.levelgen.features.placement.InBiome;
import org.betterx.bclib.api.v3.levelgen.features.placement.Is;
import org.betterx.bclib.api.v3.levelgen.features.placement.IsBasin;
import org.betterx.bclib.api.v3.levelgen.features.placement.IsNextTo;
import org.betterx.bclib.api.v3.levelgen.features.placement.NoiseFilter;
import org.betterx.bclib.api.v3.levelgen.features.placement.Offset;
import org.betterx.bclib.api.v3.levelgen.features.placement.OnEveryLayer;
import org.betterx.bclib.api.v3.levelgen.features.placement.Stencil;
import org.betterx.bclib.api.v3.levelgen.features.placement.UnderEveryLayer;

abstract class CommonPlacedFeatureBuilder<F extends class_3031<FC>, FC extends class_3037, T extends CommonPlacedFeatureBuilder<F, FC, T>> {
    protected final List<class_6797> modifications = new LinkedList<class_6797>();

    CommonPlacedFeatureBuilder() {
    }

    public T modifier(class_6797 ... modifiers) {
        for (class_6797 m : modifiers) {
            this.modifications.add(m);
        }
        return (T)this;
    }

    public T modifier(List<class_6797> modifiers) {
        this.modifications.addAll(modifiers);
        return (T)this;
    }

    public T count(int count) {
        return this.modifier(new class_6797[]{class_6793.method_39623((int)count)});
    }

    public T countMax(int count) {
        return this.modifier(new class_6797[]{class_6793.method_39624((class_6017)class_6019.method_35017((int)0, (int)count))});
    }

    public T countRange(int min, int max) {
        return this.modifier(new class_6797[]{class_6793.method_39624((class_6017)class_6019.method_35017((int)min, (int)max))});
    }

    public T all() {
        return this.modifier(All.simple());
    }

    public T stencil() {
        return this.modifier(Stencil.all());
    }

    public T stencilOneIn4() {
        return this.modifier(Stencil.oneIn4());
    }

    public T onEveryLayer(int count) {
        return this.modifier(new class_6797[]{class_5452.method_39620((int)count)});
    }

    public T onEveryLayerMax(int count) {
        return this.modifier(new class_6797[]{class_5452.method_39621((class_6017)class_6019.method_35017((int)0, (int)count))});
    }

    public T onEveryLayer() {
        return this.modifier(OnEveryLayer.simple());
    }

    public T onEveryLayerMin4() {
        return this.modifier(OnEveryLayer.min4());
    }

    public T underEveryLayer() {
        return this.modifier(UnderEveryLayer.simple());
    }

    public T underEveryLayerMin4() {
        return this.modifier(UnderEveryLayer.min4());
    }

    public T onceEvery(int n) {
        return this.modifier(new class_6797[]{class_6799.method_39659((int)n)});
    }

    public T onlyInBiome() {
        return this.modifier(new class_6797[]{class_6792.method_39614()});
    }

    public T noiseIn(double min, double max, float scaleXZ, float scaleY) {
        return this.modifier(new class_6797[]{new NoiseFilter((class_5321<class_5216.class_5487>)class_6731.field_35378, min, max, scaleXZ, scaleY)});
    }

    public T noiseAbove(double value, float scaleXZ, float scaleY) {
        return this.modifier(new class_6797[]{new NoiseFilter((class_5321<class_5216.class_5487>)class_6731.field_35378, value, Double.MAX_VALUE, scaleXZ, scaleY)});
    }

    public T noiseBelow(double value, float scaleXZ, float scaleY) {
        return this.modifier(new class_6797[]{new NoiseFilter((class_5321<class_5216.class_5487>)class_6731.field_35378, -1.7976931348623157E308, value, scaleXZ, scaleY)});
    }

    public T squarePlacement() {
        return this.modifier(new class_6797[]{class_5450.method_39639()});
    }

    public T randomHeight10FromFloorCeil() {
        return this.modifier(class_6817.field_36083);
    }

    public T randomHeight4FromFloorCeil() {
        return this.modifier(class_6817.field_36085);
    }

    public T randomHeight8FromFloorCeil() {
        return this.modifier(class_6817.field_36084);
    }

    public T randomHeight() {
        return this.modifier(class_6817.field_36082);
    }

    public T spreadHorizontal(class_6017 p) {
        return this.modifier(new class_6797[]{class_6732.method_39658((class_6017)p)});
    }

    public T spreadVertical(class_6017 p) {
        return this.modifier(new class_6797[]{class_6732.method_39658((class_6017)p)});
    }

    public T spread(class_6017 horizontal, class_6017 vertical) {
        return this.modifier(new class_6797[]{class_6732.method_39657((class_6017)horizontal, (class_6017)vertical)});
    }

    public T offset(class_2350 dir) {
        return this.modifier(Offset.inDirection(dir));
    }

    public T offset(class_2382 dir) {
        return this.modifier(new Offset(dir));
    }

    public T findSolidFloor(int distance) {
        return this.modifier(FindSolidInDirection.down(distance));
    }

    public T noiseBasedCount(float noiseLevel, int belowNoiseCount, int aboveNoiseCount) {
        return this.modifier(new class_6797[]{class_3003.method_39642((double)noiseLevel, (int)belowNoiseCount, (int)aboveNoiseCount)});
    }

    public T extendDown(int min, int max) {
        return this.modifier(new Extend(class_2350.field_11033, (class_6017)class_6019.method_35017((int)min, (int)max)));
    }

    public T inBasinOf(class_6646 ... predicates) {
        return this.modifier(new class_6797[]{new IsBasin(class_6646.method_38887((class_6646[])predicates))});
    }

    public T inOpenBasinOf(class_6646 ... predicates) {
        return this.modifier(new class_6797[]{IsBasin.openTop(class_6646.method_38887((class_6646[])predicates))});
    }

    public T is(class_6646 ... predicates) {
        return this.modifier(new class_6797[]{new Is(class_6646.method_38887((class_6646[])predicates), Optional.empty())});
    }

    public T isAbove(class_6646 ... predicates) {
        return this.modifier(new class_6797[]{new Is(class_6646.method_38887((class_6646[])predicates), Optional.of(class_2350.field_11033.method_10163()))});
    }

    public T isUnder(class_6646 ... predicates) {
        return this.modifier(new class_6797[]{new Is(class_6646.method_38887((class_6646[])predicates), Optional.of(class_2350.field_11036.method_10163()))});
    }

    public T findSolidCeil(int distance) {
        return this.modifier(FindSolidInDirection.up(distance));
    }

    public T findSolidSurface(class_2350 dir, int distance) {
        return this.modifier(new FindSolidInDirection(dir, distance, 0));
    }

    public T findSolidSurface(List<class_2350> dir, int distance, boolean randomSelect) {
        return this.modifier(new FindSolidInDirection(dir, distance, randomSelect, 0));
    }

    public T onWalls(int distance, int depth) {
        return this.modifier(new FindSolidInDirection(PlaceFacingBlockConfig.HORIZONTAL, distance, false, depth));
    }

    public T heightmap() {
        return this.modifier(class_6817.field_36078);
    }

    public T heightmapTopSolid() {
        return this.modifier(class_6817.field_36079);
    }

    public T heightmapWorldSurface() {
        return this.modifier(class_6817.field_36080);
    }

    public T extendXZ(int xzSpread) {
        class_6019 xz = class_6019.method_35017((int)0, (int)xzSpread);
        return this.modifier(new ForAll(List.of(new Extend(class_2350.field_11043, (class_6017)xz), new Extend(class_2350.field_11035, (class_6017)xz), new Extend(class_2350.field_11034, (class_6017)xz), new Extend(class_2350.field_11039, (class_6017)xz))), new ForAll(List.of(new Extend(class_2350.field_11034, (class_6017)xz), new Extend(class_2350.field_11039, (class_6017)xz), new Extend(class_2350.field_11043, (class_6017)xz), new Extend(class_2350.field_11035, (class_6017)xz))));
    }

    public T extendXYZ(int xzSpread, int ySpread) {
        class_6019 xz = class_6019.method_35017((int)0, (int)xzSpread);
        return ((CommonPlacedFeatureBuilder)this.extendXZ(xzSpread)).extendDown(1, ySpread);
    }

    public T isEmpty() {
        return this.modifier(new class_6797[]{class_6658.method_39618((class_6646)class_6646.field_35696)});
    }

    public T is(class_6646 predicate) {
        return this.modifier(new class_6797[]{class_6658.method_39618((class_6646)predicate)});
    }

    public T isNextTo(class_6646 predicate) {
        return this.modifier(new class_6797[]{new IsNextTo(predicate)});
    }

    public T belowIsNextTo(class_6646 predicate) {
        return this.modifier(new class_6797[]{new IsNextTo(predicate, class_2350.field_11033.method_10163())});
    }

    public T isNextTo(class_6646 predicate, class_2382 offset) {
        return this.modifier(new class_6797[]{new IsNextTo(predicate, offset)});
    }

    public T isOn(class_6646 predicate) {
        return this.modifier(new class_6797[]{Is.below(predicate)});
    }

    public T inBiomes(class_2960 ... biomeID) {
        return this.modifier(new class_6797[]{InBiome.matchingID(biomeID)});
    }

    public T notInBiomes(class_2960 ... biomeID) {
        return this.modifier(new class_6797[]{InBiome.notMatchingID(biomeID)});
    }

    public T isEmptyAndOn(class_6646 predicate) {
        return ((CommonPlacedFeatureBuilder)this.isEmpty()).isOn(predicate);
    }

    public T isEmptyAndOnNylium() {
        return this.isEmptyAndOn(BlockPredicates.ONLY_NYLIUM);
    }

    public T isEmptyAndOnNetherGround() {
        return this.isEmptyAndOn(BlockPredicates.ONLY_NETHER_GROUND);
    }

    public T isUnder(class_6646 predicate) {
        return this.modifier(new class_6797[]{Is.above(predicate)});
    }

    public T isEmptyAndUnder(class_6646 predicate) {
        return ((CommonPlacedFeatureBuilder)this.isEmpty()).isUnder(predicate);
    }

    public T isEmptyAndUnderNylium() {
        return this.isEmptyAndUnder(BlockPredicates.ONLY_NYLIUM);
    }

    public T isEmptyAndUnderNetherGround() {
        return this.isEmptyAndUnder(BlockPredicates.ONLY_NETHER_GROUND);
    }

    public T vanillaNetherGround(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)this.onEveryLayer(countPerLayer)).onlyInBiome();
    }

    public T betterNetherGround(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.count(countPerLayer)).squarePlacement()).onEveryLayerMin4()).onlyInBiome();
    }

    public T betterNetherCeiling(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.count(countPerLayer)).squarePlacement()).underEveryLayerMin4()).onlyInBiome();
    }

    public T betterNetherOnWall(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.count(countPerLayer)).squarePlacement()).randomHeight4FromFloorCeil()).onlyInBiome()).onWalls(16, 0);
    }

    public T betterNetherInWall(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.count(countPerLayer)).squarePlacement()).randomHeight4FromFloorCeil()).onlyInBiome()).onWalls(16, 1);
    }

    abstract class_6880<class_6796> build();

    public BCLFeatureBuilder.RandomPatch inRandomPatch(class_2960 id) {
        return BCLFeatureBuilder.startRandomPatch(id, this.build());
    }

    public BCLFeatureBuilder.RandomPatch randomBonemealDistribution(class_2960 id) {
        return this.inRandomPatch(id).tries(9).spreadXZ(3).spreadY(1);
    }
}

